library(xlsx)
library(ggplot2)
library(cowplot)

Data <- read.xlsx('CoM_Pes.xlsx', sheetIndex = 1)

Aylesbury <- Data[,7:9]
Mallard <- Data[,1:3]
Runner <- Data[,4:6]

Mallard$heel <- rep(0, 100)
Mallard$midfoot <- rep(0.5, 100)
Mallard$ThirdP <- rep(1, 100)
Mallard <- Mallard[30:70,]

MA <- ggplot(Mallard, aes(x=1:41)) +
  geom_line(aes(y = heel, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = midfoot, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = ThirdP, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_vline(xintercept = 20.5, linetype="dashed", color = "darkgrey", size=0.8) +
  geom_ribbon(aes(ymin=Mallard_Min, ymax=Mallard_Max, fill="lightyellow", color="lightyellow2"), alpha=0.7) +
  geom_line(aes(y = Mallard_Mean, color="lightyellow2"), size = 1.2) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black")) +
  theme(axis.text.x=element_blank(), axis.ticks.x=element_blank()) +
  theme(legend.position = 'none') +
  xlab("% Midstance Phase") + 
  ylab("CoM - Pes Alignment") +
  scale_color_identity(name = "",
                       breaks = c("hotpink", "hotpink", 
                                  "hotpink", "darkgrey", 
                                  "lightyellow2", "lightyellow2"),
                       labels = labels,
                       guide = "legend") +
  scale_fill_manual(values = c("lightyellow")) +
  scale_x_continuous(, expand = c(0,0))

Aylesbury$heel <- rep(0, 100)
Aylesbury$midfoot <- rep(0.5, 100)
Aylesbury$ThirdP <- rep(1, 100)
Aylesbury <- Aylesbury[30:70,]

AY <- ggplot(Aylesbury, aes(x=1:41)) +
  geom_line(aes(y = heel, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = midfoot, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = ThirdP, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_vline(xintercept = 20.5, linetype="dashed", color = "darkgrey", size=0.8) +
  geom_ribbon(aes(ymin=Aylesbury_Min, ymax=Aylesbury_Max, fill="sienna3", color="sienna3"), alpha=0.5) +
  geom_line(aes(y = Aylesbury_Mean, color="sienna3"), size = 1.2) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black")) +
  theme(axis.text.x=element_blank(), axis.ticks.x=element_blank()) +
  theme(legend.position = 'none') +
  xlab("% Midstance Phase") + 
  ylab("CoM - Pes Alignment") +
  scale_color_identity(name = "",
                       breaks = c("hotpink", "hotpink", 
                                  "hotpink", "darkgrey", 
                                  "sienna3", "sienna3"),
                       labels = labels,
                       guide = "legend") +
  scale_fill_manual(values = c("sienna3")) +
  scale_x_continuous(, expand = c(0,0))

Runner$heel <- rep(0, 100)
Runner$midfoot <- rep(0.5, 100)
Runner$ThirdP <- rep(1, 100)
Runner <- Runner[30:70,]

IR <- ggplot(Runner, aes(x=1:41)) +
  geom_line(aes(y = heel, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = midfoot, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = ThirdP, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_vline(xintercept = 20.5, linetype="dashed", color = "darkgrey", size=0.8) +
  geom_ribbon(aes(ymin=Runner_Min, ymax=Runner_Max, fill="skyblue4", color="skyblue4"), alpha=0.5) +
  geom_line(aes(y = Runner_Mean, color="skyblue4"), size = 1.2) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black")) +
  theme(axis.text.x=element_blank(), axis.ticks.x=element_blank()) +
  theme(legend.position = 'none') +
  xlab("% Midstance Phase") + 
  ylab("CoM - Pes Alignment") +
  scale_color_identity(name = "",
                       breaks = c("hotpink", "hotpink", 
                                  "hotpink", "darkgrey", 
                                  "skyblue4", "skyblue4"),
                       labels = labels,
                       guide = "legend") +
  scale_fill_manual(values = c("skyblue4")) +
  scale_x_continuous(, expand = c(0,0))

Combined <- data.frame(matrix(ncol = 3, nrow = 41))
Combined[,1] <- Mallard$Mallard_Mean
Combined[,2] <- Aylesbury$Aylesbury_Mean
Combined[,3] <- Runner$Runner_Mean
colnames(Combined) <- c("Mallard", "Aylesbury", "Runner")
Combined$heel <- rep(0, 41)
Combined$midfoot <- rep(0.5, 41)
Combined$ThirdP <- rep(1, 41)


CM <- ggplot(Combined, aes(x=1:41)) +
  geom_line(aes(y = heel, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = midfoot, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_line(aes(y = ThirdP, color="hotpink"), size = 0.8, linetype = 'dashed') +
  geom_vline(xintercept = 20.5, linetype="dashed", color = "darkgrey", size=0.8) +
  geom_line(aes(y = Mallard, color="lightyellow2"), size = 1.5) +
  geom_line(aes(y = Aylesbury, color="sienna3"), size = 1.5) +
  geom_line(aes(y = Runner, color="skyblue4"), size = 1.5) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black")) +
  theme(axis.text.x=element_blank(), axis.ticks.x=element_blank()) +
  theme(legend.position = 'none') +
  xlab("% Midstance Phase") + 
  ylab("CoM - Pes Alignment") +
  scale_color_identity(name = "",
                       breaks = c("hotpink", "hotpink", 
                                  "hotpink", "darkgrey", 
                                  "lightyellow2", "sienna3",
                                  "skyblue4"),
                       labels = labels,
                       guide = "legend") +
  scale_x_continuous(, expand = c(0,0))


tiff(filename = "CoM_Pes.tif", compression = "lzw", width = 222, height = 222, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot_grid(MA, AY, IR, CM, ncol = 2, labels = 'AUTO')

dev.off()


